-- Title: VehicleCameraAutoZoom",
-- Notes: VehicleCameraAutoZoom",
-- Author: 19BlueDragon83",
-- Version: 1.0.0.0",
-- Date: 19.11.2024", 
-- Nach einer Idee von Marhu";;

VehicleCameraAutoZoom = {};

function VehicleCameraAutoZoom.prerequisitesPresent(specializations)
    return true 
end;

function VehicleCameraAutoZoom:load(xmlFile)
end;

function VehicleCameraAutoZoom:delete()
end;

function VehicleCameraAutoZoom:readStream(streamId, connection)
end;

function VehicleCameraAutoZoom:writeStream(streamId, connection)
end;

function VehicleCameraAutoZoom:mouseEvent(posX, posY, isDown, isUp, button)
end;

function VehicleCameraAutoZoom:keyEvent(unicode, sym, modifier, isDown)
end;

function VehicleCameraAutoZoom.registerEventListeners(vehicleType)    
  for _,n in pairs( {"onEnterVehicle", "onLeaveVehicle"} ) do
    SpecializationUtil.registerEventListener(vehicleType, n, VehicleCameraAutoZoom)
  end 
end

function VehicleCameraAutoZoom:init(vehicle)
    vehicle.VehicleCameraAutoZoom = {};
    vehicle.VehicleCameraAutoZoom.initialized = true;

    if vehicle.spec_enterable ~= nil then
        -- Hole aktuelle Kamera
        local currentCamIndex = vehicle.spec_enterable.camIndex;
        if currentCamIndex ~= nil then
            local currentCamera = vehicle.spec_enterable.cameras[currentCamIndex];
            -- Prüfe ob wir bereits in der Außenansicht sind
            if currentCamera ~= nil and currentCamera.isInside == false then
                -- Nur dann zoomen wir raus
                if currentCamera.transMax ~= nil then
                    currentCamera.zoomTarget = math.min(currentCamera.transMax, math.max(currentCamera.transMin, currentCamera.zoomTarget + 12))
                    vehicle.VehicleCameraAutoZoom.initialized = false
                end
            end
        end
    end
end;

function VehicleCameraAutoZoom:onEnterVehicle()
    if self.spec_enterable ~= nil and self.getIsEntered ~= nil and self:getIsEntered() then
        if self.VehicleCameraAutoZoom == nil then
            VehicleCameraAutoZoom:init(self);
        else
            if g_gameSettings:getValue("resetCamera") then
                VehicleCameraAutoZoom:init(self);
            end;
        end;
    end;
end;

function VehicleCameraAutoZoom:onLeaveVehicle()
end;

function VehicleCameraAutoZoom:updateTick(dt)
end;

function VehicleCameraAutoZoom:draw()
end;

function VehicleCameraAutoZoom:onLeave()
end;

function VehicleCameraAutoZoom:onEnter(isControlling)
end

addModEventListener(VehicleCameraAutoZoom);