-- Title: VehicleCameraAutoZoom",
-- Notes: VehicleCameraAutoZoom",
-- Author: 19BlueDragon83",
-- Version: 1.0.0.0",
-- Date: 19.11.2024", 
-- Nach einer Idee von Marhu";;

VehicleCameraAutoZoom_Register = {};

source(Utils.getFilename("VehicleCameraAutoZoom.lua", g_currentModDirectory))


VehicleCameraAutoZoom_Register = {};
VehicleCameraAutoZoom_Register.modDirectory = g_currentModDirectory;

local modDesc = loadXMLFile("modDesc", g_currentModDirectory .. "modDesc.xml");
VehicleCameraAutoZoom_Register.version = getXMLString(modDesc, "modDesc.version");

if g_specializationManager:getSpecializationByName("VehicleCameraAutoZoom") == nil then
	g_specializationManager:addSpecialization("VehicleCameraAutoZoom", "VehicleCameraAutoZoom", Utils.getFilename("VehicleCameraAutoZoom.lua",  g_currentModDirectory), nil)
	
	local VehicleCameraAutoZoomSpecName = g_currentModName .. ".VehicleCameraAutoZoom"
	
	if VehicleCameraAutoZoom == nil then 
	  print("ERROR: unable to add specialization 'VehicleCameraAutoZoom'")
	else 
	  for i, vehicle in pairs(g_vehicleTypeManager.types) do
			if vehicle ~= nil then 
				local isDrivable  = false
				local isEnterable = false
				local hasMotor    = false 
				for name in pairs(vehicle.specializationsByName) do
					if name == "drivable"  then 
						isDrivable = true 
					elseif name == "motorized" then 
						hasMotor = true 
					elseif name == "enterable" then 
						isEnterable = true 
					end 
				end 
				
				if isDrivable and isEnterable and hasMotor then 
	
					if vehicle.specializationsByName["VehicleCameraAutoZoom"] == nil then
						g_vehicleTypeManager:addSpecialization(i, VehicleCameraAutoZoomSpecName)
						vehicle.hasVehicleCameraAutoZoomSpec = true;
					end;
				end 
			end 
	  end   
	end 
end 

addModEventListener(VehicleCameraAutoZoom_Register);